/*
 * Decompiled with CFR 0.152.
 */
package net.darkblade.mini_pekka.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.darkblade.mini_pekka.client.ModBlockEntityModelLayers;
import net.darkblade.mini_pekka.server.block.ModSkullBlock;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModSkullBlockRenderer
extends SkullBlockRenderer
implements BlockEntityRenderer<SkullBlockEntity> {
    private final Map<SkullBlock.Type, SkullModelBase> modelByType;
    public static final ResourceLocation MINI_PEKKA_HEAD_TEX = new ResourceLocation("mpekka", "textures/entity/mini_pk_head/mini_pk_head.png");

    public ModSkullBlockRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        this.modelByType = ModSkullBlockRenderer.m_173661_(ctx.m_173585_());
        f_112519_.put(ModSkullBlock.Types.MINI_PEKKA, MINI_PEKKA_HEAD_TEX);
    }

    public void m_6922_(SkullBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        float anim = be.m_261082_(partialTicks);
        BlockState state = be.m_58900_();
        boolean wall = state.m_60734_() instanceof WallSkullBlock;
        Direction facing = wall ? (Direction)state.m_61143_((Property)WallSkullBlock.f_58097_) : null;
        int rotSegment = wall ? RotationSegment.m_245225_((Direction)facing.m_122424_()) : (Integer)state.m_61143_((Property)SkullBlock.f_56314_);
        float yRotDeg = RotationSegment.m_245107_((int)rotSegment);
        SkullBlock.Type type = ((AbstractSkullBlock)state.m_60734_()).m_48754_();
        SkullModelBase model = this.modelByType.get(type);
        RenderType renderType = ModSkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)be.m_59779_());
        ModSkullBlockRenderer.m_173663_(facing, yRotDeg, anim, pose, buffers, packedLight, model, renderType);
    }

    public static void m_173663_(@Nullable Direction facing, float yRotDeg, float anim, PoseStack pose, MultiBufferSource buffers, int light, SkullModelBase model, RenderType rt) {
        pose.m_85836_();
        if (facing == null) {
            pose.m_252880_(0.5f, 0.0f, 0.5f);
        } else {
            float horizontal = 0.25f;
            float vertical = 0.25f;
            pose.m_252880_(0.5f - (float)facing.m_122429_() * horizontal, vertical, 0.5f - (float)facing.m_122431_() * horizontal);
        }
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vc = buffers.m_6299_(rt);
        model.m_6251_(anim, yRotDeg, 0.0f);
        model.m_7695_(pose, vc, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    public static Map<SkullBlock.Type, SkullModelBase> m_173661_(EntityModelSet models) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModSkullBlock.Types.MINI_PEKKA, (Object)new SkullModel(models.m_171103_(ModBlockEntityModelLayers.MINI_PK_HEAD)));
        return builder.build();
    }
}

